import os.path

import torch
import numpy as np


def to_pt(np_matrix, enable_cuda=False, type='long'):
    if type == 'long':
        if enable_cuda:
            return torch.autograd.Variable(torch.from_numpy(np_matrix).type(torch.LongTensor).cuda())
        else:
            return torch.autograd.Variable(torch.from_numpy(np_matrix).type(torch.LongTensor))
    elif type == 'float':
        if enable_cuda:
            return torch.autograd.Variable(torch.from_numpy(np_matrix).type(torch.FloatTensor).cuda())
        else:
            return torch.autograd.Variable(torch.from_numpy(np_matrix).type(torch.FloatTensor))


def to_np(x):
    if isinstance(x, np.ndarray):
        return x
    return x.data.cpu().numpy()


def get_distrib_q_model_save_path(agent, date_label, debug_msg):
    if not os.path.exists(agent.save_model_dir + agent.experiment_tag):
        os.mkdir(agent.save_model_dir + agent.experiment_tag)
    save_to_path = agent.save_model_dir + agent.experiment_tag + \
                   '/{12}saved_{0}{1}{2}_model_tau-{3}_supp-{4}_gamma-{5}_train-{6}{7}_{8}_data-{9}{10}{11}'.format(
                       agent.sports,
                       '_{0}rnn_maxlen-{1}'.format('dynamic_' if agent.apply_dynamic_trace_length else '',
                                                   agent.max_trace_length) if agent.apply_rnn else '',
                       '-resnet_num-{0}'.format(agent.resnet_layer_num) if agent.apply_resnet else '',
                       agent.num_tau,
                       agent.num_supp,
                       agent.gamma,
                       agent.train_rate,
                       '_cut' if agent.cut_at_goal else '',
                       date_label,
                       'divdate' if agent.apply_data_date_div else '',
                       'splitSA' if agent.split_state_action_resnet else '',
                       '_keepGoal' if agent.keep_goal_state else '',
                       debug_msg,
                   )
    return save_to_path


def get_maf_save_path(agent, date_label, debug_msg):
    maf_model_save_mother_dir = "../save_model/nf/saved_{0}_maf_" \
                                "{12}type-{1}_blocks-{2}_inputs-{3}" \
                                "_hidden-{4}_cond-{5}_lr-{6}{7}{8}{9}{10}_{11}".format(
        agent.sports,
        agent.maf_flow_type,
        agent.maf_num_blocks,
        agent.maf_num_inputs,
        agent.maf_num_hidden,
        agent.maf_num_cond_inputs,
        agent.maf_lr,
        '_history' if agent.maf_apply_history else '',
        '_condAct' if agent.maf_cond_act else '',
        '_condValue' if agent.maf_cond_value else '',
        '_expectBase' if agent.use_expectation_base else '',
        date_label,
        debug_msg,
    )
    return maf_model_save_mother_dir
